/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.mapgen;

import java.util.Random;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.world.classic.ChunkGenTFC;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;

public class MapGenRiverRavine
extends MapGenBase {
    private final float[] multipliers = new float[256];
    private final int riverRavineRarity;

    public MapGenRiverRavine(int rarity) {
        this.riverRavineRarity = rarity;
        this.field_75040_a = 32;
    }

    public void func_186125_a(World worldIn, int x, int z, ChunkPrimer primer) {
        this.func_180701_a(worldIn, x, z, x, z, primer);
    }

    protected void func_180701_a(World worldIn, int chunkX, int chunkZ, int originalX, int originalZ, ChunkPrimer chunkPrimerIn) {
        if (this.field_75038_b.nextInt(this.riverRavineRarity) != 0) {
            return;
        }
        double x = chunkX * 16 + this.field_75038_b.nextInt(16);
        double y = 80.0;
        double z = chunkZ * 16 + this.field_75038_b.nextInt(16);
        float angleY = this.field_75038_b.nextFloat() * (float)Math.PI * 2.0f;
        float angleZ = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
        float angleX = (this.field_75038_b.nextFloat() * 2.0f + this.field_75038_b.nextFloat()) * 2.0f;
        this.generateRavine(this.field_75038_b.nextLong(), chunkX, chunkZ, chunkPrimerIn, x, y, z, angleX, angleY, angleZ, y);
    }

    protected void generateRavine(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double startX, double startY, double startZ, float angleX, float angleY, float angleZ, double waterHeight) {
        Random rand = new Random(seed);
        double worldX = chunkX * 16 + 8;
        double worldZ = chunkZ * 16 + 8;
        float runningZMultiplier = 0.0f;
        float runningYMultiplier = 0.0f;
        int rounds = this.field_75040_a * 16 - 16 - rand.nextInt((this.field_75040_a * 16 - 16) / 4);
        float f = 1.0f + rand.nextFloat() * rand.nextFloat() * 1.0f;
        this.multipliers[0] = f * f;
        for (int i = 1; i < 256; ++i) {
            if (rand.nextInt(3) == 0) {
                f = 1.0f + rand.nextFloat() * rand.nextFloat() * 1.0f;
            }
            this.multipliers[i] = f * f;
        }
        block1: for (int round = 0; round < rounds; ++round) {
            int x;
            double min = 3.5 + (double)(MathHelper.func_76126_a((float)((float)round * (float)Math.PI / (float)rounds)) * angleX * 1.0f);
            double max = min * 0.8;
            min *= (double)rand.nextFloat() * 0.25 + 0.75;
            max *= (double)rand.nextFloat() * 0.25 + 0.75;
            float cosZ = MathHelper.func_76134_b((float)angleZ);
            float sinZ = MathHelper.func_76126_a((float)angleZ);
            startX += (double)(MathHelper.func_76134_b((float)angleY) * cosZ);
            startY += (double)sinZ;
            startZ += (double)(MathHelper.func_76126_a((float)angleY) * cosZ);
            angleZ *= 0.7f;
            angleZ += runningZMultiplier * 0.05f;
            angleY += runningYMultiplier * 0.05f;
            runningZMultiplier *= 0.8f;
            runningYMultiplier *= 0.5f;
            runningZMultiplier += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 2.0f;
            runningYMultiplier += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 4.0f;
            if (rand.nextInt(4) == 0) continue;
            double xOffset = startX - worldX;
            double zOffset = startZ - worldZ;
            double roundsLeft = rounds - round;
            double radius = angleX + 2.0f + 16.0f;
            if (xOffset * xOffset + zOffset * zOffset - roundsLeft * roundsLeft > radius * radius) {
                return;
            }
            if (!(startX >= worldX - 16.0 - min * 2.0 && startZ >= worldZ - 16.0 - min * 2.0 && startX <= worldX + 16.0 + min * 2.0 && startZ <= worldZ + 16.0 + min * 2.0)) continue;
            int xMin = MathHelper.func_76128_c((double)(startX - min)) - chunkX * 16 - 1;
            int xMax = MathHelper.func_76128_c((double)(startX + min)) - chunkX * 16 + 1;
            int yMin = MathHelper.func_76128_c((double)(startY - max)) - 1;
            int yMax = MathHelper.func_76128_c((double)(startY + max)) + 1;
            int zMin = MathHelper.func_76128_c((double)(startZ - min)) - chunkZ * 16 - 1;
            int zMax = MathHelper.func_76128_c((double)(startZ + min)) - chunkZ * 16 + 1;
            if (xMin < 0) {
                xMin = 0;
            }
            if (xMax > 16) {
                xMax = 16;
            }
            if (yMin < 1) {
                yMin = 1;
            }
            if (yMax > 250) {
                yMax = 250;
            }
            if (zMin < 0) {
                zMin = 0;
            }
            if (zMax > 16) {
                zMax = 16;
            }
            for (x = Math.max(xMin - 1, 0); x < Math.min(xMax + 1, 16); ++x) {
                for (int z = Math.max(zMin - 1, 0); z < Math.min(zMax + 1, 16); ++z) {
                    for (int y = Math.min(yMax + 1, 250); y >= Math.max(yMin - 2, 1); --y) {
                        if (BlocksTFC.isWater(primer.func_177856_a(x, y, z))) continue block1;
                    }
                }
            }
            for (x = xMin; x < xMax; ++x) {
                double xNormalized = ((double)(x + chunkX * 16) + 0.5 - startX) / min;
                for (int z = zMin; z < zMax; ++z) {
                    double zNormalized = ((double)(z + chunkZ * 16) + 0.5 - startZ) / min;
                    if (xNormalized * xNormalized + zNormalized * zNormalized >= 1.0) continue;
                    for (int y = yMax - 1; y >= yMin; --y) {
                        double yNormalized = ((double)y + 0.5 - startY) / max;
                        if ((xNormalized * xNormalized + zNormalized * zNormalized) * (double)this.multipliers[y] + yNormalized * yNormalized / 6.0 >= 1.0 || !BlocksTFC.isRawStone(primer.func_177856_a(x, y, z)) && !BlocksTFC.isSoil(primer.func_177856_a(x, y, z))) continue;
                        if (y < 20) {
                            primer.func_177855_a(x, y, z, ChunkGenTFC.LAVA);
                            continue;
                        }
                        if ((double)y < waterHeight) {
                            primer.func_177855_a(x, y, z, ChunkGenTFC.FRESH_WATER);
                            continue;
                        }
                        primer.func_177855_a(x, y, z, ChunkGenTFC.AIR);
                    }
                }
            }
        }
    }
}

